/*
 * Decompiled with CFR 0.152.
 */
package com.useful.ucars.util;

import com.useful.ucars.ucars;
import com.useful.ucars.util.UMeta;
import com.useful.ucars.util.USchLocks;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class UEntityMeta {
    private static volatile Map<UUID, Object> entityMetaObjs = new ConcurrentHashMap<UUID, Object>(100, 0.75f, 2);
    private static volatile Map<UUID, WeakReference<Entity>> entityObjs = new ConcurrentHashMap<UUID, WeakReference<Entity>>(100, 0.75f, 2);

    public static void cleanEntityObjs() {
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)ucars.plugin, new Runnable(){

            @Override
            public void run() {
                for (Map.Entry entry : entityObjs.entrySet()) {
                    UUID entID = (UUID)entry.getKey();
                    WeakReference val = (WeakReference)entry.getValue();
                    if (val != null && val.get() != null) continue;
                    entityObjs.remove(entID);
                    Object metaObj = entityMetaObjs.remove(entID);
                    if (metaObj == null) continue;
                    UMeta.removeAllMeta(metaObj);
                }
                UMeta.clean();
            }
        }, 1180L, 1180L);
    }

    private static void setEntityObj(Entity e) {
        if (e instanceof Player) {
            return;
        }
        entityObjs.put(e.getUniqueId(), new WeakReference<Entity>(e));
    }

    private static void delEntityObj(Entity e) {
        if (e instanceof Player) {
            return;
        }
        entityObjs.remove(e.getUniqueId());
    }

    public static void printOutMeta(Entity e) {
        StringBuilder sb = new StringBuilder();
        Map<String, List<MetadataValue>> metas = UMeta.getAllMeta(UEntityMeta.getMetaObj(e));
        for (String key : new ArrayList<String>(metas.keySet())) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(key);
        }
        Bukkit.broadcastMessage((String)(e.getUniqueId() + ": " + sb.toString()));
    }

    public static void removeAllMeta(Entity e) {
        Object o = entityMetaObjs.get(e.getUniqueId());
        entityMetaObjs.remove(e.getUniqueId());
        UEntityMeta.delEntityObj(e);
        if (o != null) {
            UMeta.removeAllMeta(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object getMetaObj(Entity e) {
        if (e == null) {
            return null;
        }
        Object obj = entityMetaObjs.get(e.getUniqueId());
        if (obj == null) {
            Object object = USchLocks.getMonitor("newMetaObjMonitor" + e.getUniqueId());
            synchronized (object) {
                obj = entityMetaObjs.get(e.getUniqueId());
                if (obj == null) {
                    obj = new Object();
                    entityMetaObjs.put(e.getUniqueId(), obj);
                    UEntityMeta.setEntityObj(e);
                }
            }
        }
        return obj;
    }

    public static void setMetadata(Entity entity, String metaKey, MetadataValue value) {
        UEntityMeta.setEntityObj(entity);
        UMeta.getMeta(UEntityMeta.getMetaObj(entity), metaKey).add(value);
    }

    public static List<MetadataValue> getMetadata(Entity entity, String metaKey) {
        return UMeta.getAllMeta(UEntityMeta.getMetaObj(entity)).get(metaKey);
    }

    public static boolean hasMetadata(Entity entity, String metaKey) {
        return UMeta.getAllMeta(UEntityMeta.getMetaObj(entity)).containsKey(metaKey);
    }

    public static void removeMetadata(Entity entity, String metaKey) {
        UMeta.removeMeta(UEntityMeta.getMetaObj(entity), metaKey);
    }
}

