/*
 * Decompiled with CFR 0.152.
 */
package net.stormdev.ucars.trade.AIVehicles.spawning;

import com.useful.ucars.CarHealthData;
import com.useful.ucars.CartOrientationUtil;
import com.useful.ucars.ucars;
import com.useful.ucars.util.UEntityMeta;
import com.useful.ucarsCommon.StatValue;
import java.util.ArrayList;
import java.util.List;
import net.stormdev.ucars.entity.Car;
import net.stormdev.ucars.entity.CarMinecraftEntity;
import net.stormdev.ucars.trade.AIVehicles.AIRouter;
import net.stormdev.ucars.trade.AIVehicles.AITrackFollow;
import net.stormdev.ucars.trade.AIVehicles.DynamicLagReducer;
import net.stormdev.ucars.trade.AIVehicles.TrackingData;
import net.stormdev.ucars.trade.AIVehicles.VelocityData;
import net.stormdev.ucars.trade.AIVehicles.spawning.AICarPassengerProvider;
import net.stormdev.ucars.trade.AIVehicles.spawning.AISpawnManager;
import net.stormdev.ucars.trade.AIVehicles.spawning.SpawnMethod;
import net.stormdev.ucars.trade.AIVehicles.spawning.VillagerAICarPassengerProvider;
import net.stormdev.ucars.trade.main;
import net.stormdev.ucars.utils.CarGenerator;
import net.stormdev.ucarstrade.cars.CarPresets;
import net.stormdev.ucarstrade.cars.DrivenCar;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Vehicle;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public abstract class AbstractAISpawnManager
implements AISpawnManager {
    protected main plugin;
    protected volatile boolean enabled;
    protected volatile boolean fullEnable;
    protected static Material roadEdge;
    protected Material junction;
    protected List<String> aiNames;
    protected static int cap;
    protected static volatile int liveCap;
    protected static volatile int spawnedCount;
    private AICarPassengerProvider carPassengerProvider = new VillagerAICarPassengerProvider();

    public AbstractAISpawnManager(main plugin, boolean enabled) {
        this.plugin = plugin;
        this.enabled = enabled;
        this.fullEnable = enabled;
        String edgeRaw = main.config.getString("general.ai.roadEdgeBlock");
        String junRaw = main.config.getString("general.ai.junctionBlock");
        this.aiNames = main.config.getStringList("general.ai.names");
        cap = main.config.getInt("general.ai.limit");
        liveCap = 5;
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)main.plugin, new Runnable(){

            @Override
            public void run() {
                int score = DynamicLagReducer.getResourceScore();
                int newCap = liveCap;
                double tps = DynamicLagReducer.getTPS();
                if (score > 75 && tps > 19.2) {
                    ++newCap;
                } else if (score < 70 || tps < 18.0) {
                    newCap = (int)((double)newCap * 0.5);
                    newCap -= 10;
                } else if (score < 70 || tps < 18.6) {
                    newCap -= 10;
                } else if (score < 70 || tps < 18.8) {
                    newCap -= 5;
                } else if (score < 75 || tps < 19.1) {
                    --newCap;
                }
                if (newCap != liveCap) {
                    if (newCap > cap) {
                        newCap = cap;
                    }
                    if (newCap < 1) {
                        newCap = 1;
                    }
                    liveCap = newCap;
                }
            }
        }, 100L, 100L);
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)main.plugin, new Runnable(){

            @Override
            public void run() {
                int aiCars = 0;
                for (World world : new ArrayList(Bukkit.getWorlds())) {
                    for (Entity e : new ArrayList(world.getEntities())) {
                        DrivenCar c;
                        Vehicle cart;
                        if (!(e instanceof Vehicle) || !UEntityMeta.hasMetadata((Entity)(cart = (Vehicle)e), (String)"trade.npc") || (c = main.plugin.carSaver.getCarInUse((Entity)cart)) == null || !c.isNPC()) continue;
                        ++aiCars;
                    }
                }
                spawnedCount = aiCars;
            }
        }, 12000L, 12000L);
        new DynamicLagReducer().start();
        roadEdge = Material.getMaterial((String)edgeRaw);
        this.junction = Material.getMaterial((String)junRaw);
        if (roadEdge == null || this.junction == null) {
            main.logger.info("Didn't enable AIs as configuration is invalid!");
            enabled = false;
        }
        if (enabled) {
            main.plugin.getLogger().info("AI Cars enabled successfully!");
            this.initSpawnTask();
        }
    }

    @Override
    public AICarPassengerProvider getCarPassengerProvider() {
        return this.carPassengerProvider;
    }

    @Override
    public void setCarPassengerProvider(AICarPassengerProvider provider) {
        this.carPassengerProvider = provider;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public abstract void initSpawnTask();

    @Override
    public boolean isNPCCarsEnabled() {
        return this.fullEnable;
    }

    @Override
    public boolean isNPCCarsSpawningNow() {
        return this.enabled;
    }

    @Override
    public int getCurrentAICap() {
        return liveCap;
    }

    @Override
    public int getMaxAICap() {
        return cap;
    }

    @Override
    public int getSpawnedAICount() {
        return spawnedCount;
    }

    @Override
    public void decrementSpawnedAICount() {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)main.plugin, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                AbstractAISpawnManager abstractAISpawnManager = AbstractAISpawnManager.this;
                synchronized (abstractAISpawnManager) {
                    if (--spawnedCount < 0) {
                        spawnedCount = 0;
                    }
                }
            }
        });
    }

    @Override
    public void incrementSpawnedAICount() {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)main.plugin, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                AbstractAISpawnManager abstractAISpawnManager = AbstractAISpawnManager.this;
                synchronized (abstractAISpawnManager) {
                    ++spawnedCount;
                }
            }
        });
    }

    @Override
    public void setCurrentAICap(int cap) {
        liveCap = cap;
    }

    @Override
    public synchronized void setNPCsCurrentlySpawning(boolean flag) {
        this.enabled = flag;
    }

    @Override
    public void spawnNPCCar(Location spawn, final BlockFace carriagewayDir) {
        float yaw;
        spawn = spawn.add(0.5, 0.0, 0.5);
        Location dirLoc = new Location(spawn.getWorld(), 0.0, 0.0, 0.0);
        dirLoc.setDirection(new Vector(carriagewayDir.getModX(), 0, carriagewayDir.getModZ()).normalize());
        for (yaw = dirLoc.getYaw(); yaw < 0.0f; yaw = 360.0f + yaw) {
        }
        while (yaw >= 360.0f) {
            yaw -= 360.0f;
        }
        spawn.setYaw(yaw);
        final float ya = yaw;
        final Location spawnLoc = spawn;
        final DrivenCar c = CarGenerator.gen().setNPC(true);
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)main.plugin, new Runnable(){

            @Override
            public void run() {
                c.getPreset();
                ArrayList<Player> nearbyPlayers = new ArrayList<Player>();
                final ArrayList<Entity> nearby = new ArrayList<Entity>();
                if (main.plugin.aiSpawnMethod.equals((Object)SpawnMethod.WORLD_PROBE)) {
                    ArrayList all;
                    try {
                        all = new ArrayList(spawnLoc.getWorld().getEntities());
                    }
                    catch (Exception e1) {
                        return;
                    }
                    Vector loc = spawnLoc.toVector().clone();
                    for (Entity e : all) {
                        Vector pLoc = e.getLocation().toVector();
                        double dist = pLoc.distanceSquared(loc);
                        if (dist < 2.0 && e instanceof Vehicle) {
                            nearby.add(e);
                        }
                        if (!(dist < AIRouter.PLAYER_RADIUS_SQ) || !(e instanceof Player)) continue;
                        nearbyPlayers.add((Player)e);
                    }
                }
                final ArrayList<Player> nearbyPlayersList = nearbyPlayers;
                final String name = AbstractAISpawnManager.this.randomName();
                AbstractAISpawnManager.this.plugin.getServer().getScheduler().runTask((Plugin)AbstractAISpawnManager.this.plugin, new Runnable(){

                    @Override
                    public void run() {
                        if (!spawnLoc.getChunk().isLoaded()) {
                            return;
                        }
                        CarMinecraftEntity hce = new CarMinecraftEntity(spawnLoc.clone());
                        hce.setHitBoxX(0.6f);
                        hce.setHitBoxZ(-1.0f);
                        hce.setMaxPassengers(c.getMaxPassengers());
                        hce.setBoatOffsetDeg(c.getBoatOrientationOffsetDeg());
                        final Car m = hce.spawn();
                        float yaw = spawnLoc.getYaw() + 90.0f;
                        if (yaw < 0.0f) {
                            yaw = 360.0f + yaw;
                        } else if (yaw >= 360.0f) {
                            yaw -= 360.0f;
                        }
                        CarPresets.CarPreset cp = c.getPreset();
                        if (cp != null && cp.hasDisplayBlock()) {
                            m.setDisplay(new ItemStack(cp.getDisplayBlock().getItemType(), 1, (short)cp.getDisplayBlock().getData()), cp.getDisplayBlockOffset());
                        } else if (c.getBaseDisplayBlock() != null) {
                            m.setDisplay(new ItemStack(c.getBaseDisplayBlock().getItemType(), 1, (short)c.getBaseDisplayBlock().getData()), 0.0);
                        }
                        CartOrientationUtil.setYaw((Entity)m, (float)yaw);
                        if (main.plugin.aiSpawnMethod.equals((Object)SpawnMethod.WORLD_PROBE)) {
                            if (nearby.size() > 1) {
                                m.remove();
                            }
                            ArrayList nearby2 = new ArrayList(m.getNearbyEntities(AIRouter.PLAYER_RADIUS, 50.0, AIRouter.PLAYER_RADIUS));
                            for (Entity e : new ArrayList(nearby2)) {
                                if (!(e instanceof Vehicle)) {
                                    nearby2.remove(e);
                                    continue;
                                }
                                if (!(e instanceof Player)) continue;
                                nearbyPlayersList.add((Player)e);
                            }
                            if (nearby2.size() > 2) {
                                m.remove();
                                return;
                            }
                        }
                        LivingEntity v = AbstractAISpawnManager.this.getCarPassengerProvider().spawnNewPassenger(spawnLoc.clone(), c, name);
                        UEntityMeta.setMetadata((Entity)v, (String)"trade.npcvillager", (MetadataValue)new StatValue((Object)true, (Plugin)main.plugin));
                        Location sl = spawnLoc.clone();
                        sl.setYaw(sl.getYaw() - 90.0f);
                        AbstractAISpawnManager.this.getCarPassengerProvider().setPassengerYaw(v, sl.getYaw() - 90.0f);
                        c.setId(m.getUniqueId());
                        UEntityMeta.setMetadata((Entity)m, (String)"trade.npc", (MetadataValue)new StatValue((Object)new VelocityData(carriagewayDir, null, m.getLocation()), (Plugin)AbstractAISpawnManager.this.plugin));
                        CartOrientationUtil.setYaw((Entity)m, (float)ya);
                        m.addPassenger((Entity)v);
                        Bukkit.getScheduler().runTaskLater((Plugin)main.plugin, new Runnable(){

                            @Override
                            public void run() {
                                main.plugin.protocolManipulator.ensurePassengersAttached(m);
                            }
                        }, 40L);
                        ucars.listener.updateCarHealthHandler((Entity)m, new CarHealthData(c.getHealth(), (Plugin)AbstractAISpawnManager.this.plugin));
                        if (!m.isDead() && m.isValid() && v.isValid() && !v.isDead()) {
                            AbstractAISpawnManager.this.plugin.carSaver.carNowInUse((Entity)m, c);
                            AbstractAISpawnManager.this.incrementSpawnedAICount();
                        }
                    }
                });
            }
        });
    }

    @Override
    public void followRoadAndSpawnCarFromTrackerBlock(Location trackerBlockLoc, BlockFace followDir) {
        if (!this.plugin.aiSpawns.isNPCCarsEnabled()) {
            return;
        }
        Block current = trackerBlockLoc.getBlock();
        for (int distance = this.randomDistanceAmount(); distance > 0; --distance) {
            TrackingData data = AITrackFollow.nextBlock(current, new VelocityData(followDir, new Vector(0, 0, 0), null), AITrackFollow.carriagewayDirection(current), null);
            current = data.nextBlock;
            followDir = data.dir;
        }
        Block toSpawn = current.getRelative(BlockFace.UP);
        while (AIRouter.isTrackBlock(toSpawn.getType()) && toSpawn.getY() <= 256) {
            toSpawn = toSpawn.getRelative(BlockFace.UP);
        }
        Location spawnLoc = toSpawn.getLocation().add(0.0, 1.5, 0.0);
        if (!spawnLoc.getBlock().isEmpty() && !(spawnLoc = spawnLoc.add(0.0, 0.6, 0.0)).getBlock().isEmpty()) {
            return;
        }
        BlockFace carDirection = followDir;
        carDirection = AITrackFollow.carriagewayDirection(current).getDirection();
        if (carDirection == null) {
            return;
        }
        this.spawnNPCCar(spawnLoc, carDirection);
    }

    public int randomDistanceAmount() {
        return main.random.nextInt(15) + 10;
    }

    public int randomDirAmount() {
        return main.random.nextInt(5) + 1;
    }

    public int randomDir2Amount() {
        return main.random.nextInt(5) + 5;
    }

    public int randomDir3Amount() {
        return main.random.nextInt(10) + 20;
    }

    public BlockFace randomFace() {
        int rand = main.random.nextInt(8);
        switch (rand) {
            case 0: {
                return BlockFace.NORTH;
            }
            case 1: {
                return BlockFace.NORTH_EAST;
            }
            case 2: {
                return BlockFace.EAST;
            }
            case 3: {
                return BlockFace.SOUTH_EAST;
            }
            case 4: {
                return BlockFace.SOUTH;
            }
            case 5: {
                return BlockFace.SOUTH_WEST;
            }
            case 6: {
                return BlockFace.WEST;
            }
            case 7: {
                return BlockFace.NORTH_WEST;
            }
        }
        return BlockFace.NORTH;
    }

    public String randomName() {
        if (this.aiNames == null) {
            return "Citizen";
        }
        return this.aiNames.get(main.random.nextInt(this.aiNames.size()));
    }

    static {
        cap = 30;
        liveCap = 5;
        spawnedCount = 0;
    }
}

