/*
 * Decompiled with CFR 0.152.
 */
package net.stormdev.ucars.trade;

import com.useful.ucars.CarHealthData;
import com.useful.ucars.CartOrientationUtil;
import com.useful.ucars.ucars;
import com.useful.ucars.util.UEntityMeta;
import com.useful.ucarsCommon.StatValue;
import java.util.regex.Pattern;
import net.stormdev.ucars.entity.Car;
import net.stormdev.ucars.entity.CarMinecraftEntity;
import net.stormdev.ucars.trade.Lang;
import net.stormdev.ucars.trade.main;
import net.stormdev.ucarstrade.cars.CarPresets;
import net.stormdev.ucarstrade.cars.DrivenCar;
import net.stormdev.ucarstrade.displays.DisplayManager;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class CarPlaceAPI {
    public static Entity placeCar(DrivenCar carData, Location placeLoc, Player placer, float direction) {
        Location loc = placeLoc.clone().add(0.0, 1.6, 0.0);
        loc.setYaw(direction + 90.0f);
        Block in = loc.getBlock();
        CarMinecraftEntity hce = new CarMinecraftEntity(loc.clone().add(0.0, 0.0, 0.0));
        hce.setHitBoxX(carData.getHitboxX());
        hce.setHitBoxZ(carData.getHitboxZ());
        hce.setMaxPassengers(carData.getMaxPassengers());
        hce.setBoatOffsetDeg(carData.getBoatOrientationOffsetDeg());
        Car car = hce.spawn();
        float yaw = direction;
        if (yaw < 0.0f) {
            yaw = 360.0f + yaw;
        } else if (yaw >= 360.0f) {
            yaw -= 360.0f;
        }
        CartOrientationUtil.setYaw((Entity)car, (float)(yaw + 90.0f));
        CarPresets.CarPreset cp = carData.getPreset();
        if (cp != null && cp.hasDisplayBlock()) {
            car.setDisplay(new ItemStack(cp.getDisplayBlock().getItemType(), 1, (short)cp.getDisplayBlock().getData()), cp.getDisplayBlockOffset());
        } else if (carData.getBaseDisplayBlock() != null) {
            car.setDisplay(new ItemStack(carData.getBaseDisplayBlock().getItemType(), 1, (short)carData.getBaseDisplayBlock().getData()), 0.0);
        }
        in = car.getLocation().getBlock();
        Block n = in.getRelative(BlockFace.NORTH);
        Block w = in.getRelative(BlockFace.WEST);
        Block nw = in.getRelative(BlockFace.NORTH_WEST);
        Block ne = in.getRelative(BlockFace.NORTH_EAST);
        Block sw = in.getRelative(BlockFace.SOUTH_WEST);
        if ((!in.isEmpty() && !in.isLiquid() || !n.isEmpty() && !n.isLiquid() || !w.isEmpty() && !w.isLiquid() || !ne.isEmpty() && !ne.isLiquid() || !nw.isEmpty() && !nw.isLiquid() || !sw.isEmpty() && !sw.isLiquid()) && placer != null) {
            car.remove();
            return null;
        }
        double health = carData.getHealth();
        CarHealthData chd = ucars.listener.getCarHealthHandler((Entity)car);
        chd.setHealth(health);
        ucars.listener.updateCarHealthHandler((Entity)car, chd);
        UEntityMeta.setMetadata((Entity)car, (String)"trade.car", (MetadataValue)new StatValue((Object)true, (Plugin)main.plugin));
        carData.setId(car.getUniqueId());
        main.plugin.carSaver.carNowInUse((Entity)car, carData);
        String name = carData.getName();
        String placeMsg = Lang.get("general.place.msg");
        placeMsg = main.colors.getInfo() + placeMsg.replaceAll(Pattern.quote("%name%"), "'" + name + "'");
        if (placer != null) {
            placer.sendMessage(placeMsg);
            DisplayManager.fillCar((Entity)car, carData, placer);
        }
        return car;
    }
}

