/*
 * Decompiled with CFR 0.152.
 */
package net.stormdev.ucars.trade;

import com.comphenix.protocol.ProtocolLibrary;
import com.useful.uCarsAPI.ItemCarCheck;
import com.useful.uCarsAPI.uCarsAPI;
import com.useful.ucars.CartOrientationUtil;
import com.useful.ucars.Colors;
import com.useful.ucars.ucars;
import com.useful.ucars.util.UEntityMeta;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.logging.Level;
import net.milkbowl.vault.economy.Economy;
import net.stormdev.ucars.shops.CarShop;
import net.stormdev.ucars.trade.AIVehicles.AIRouter;
import net.stormdev.ucars.trade.AIVehicles.routing.RouteMethod;
import net.stormdev.ucars.trade.AIVehicles.spawning.AISpawnManager;
import net.stormdev.ucars.trade.AIVehicles.spawning.AIWorldProbingSpawnManager;
import net.stormdev.ucars.trade.AIVehicles.spawning.SpawnMethod;
import net.stormdev.ucars.trade.AIVehicles.spawning.nodes.AINodesSpawnManager;
import net.stormdev.ucars.trade.CarCalculations;
import net.stormdev.ucars.trade.CarSaver;
import net.stormdev.ucars.trade.CustomLogger;
import net.stormdev.ucars.trade.Lang;
import net.stormdev.ucars.trade.UTradeCommandExecutor;
import net.stormdev.ucars.trade.UTradeListener;
import net.stormdev.ucars.trade.guis.IconMenu;
import net.stormdev.ucars.trade.guis.IconMenuListener;
import net.stormdev.ucars.utils.ItemRename;
import net.stormdev.ucars.utils.OverridenCartOrientationUtil;
import net.stormdev.ucars.utils.SalesManager;
import net.stormdev.ucars.utils.TradeBoothClickEvent;
import net.stormdev.ucars.utils.TradeBoothMenuType;
import net.stormdev.ucarstrade.ItemCarValidation;
import net.stormdev.ucarstrade.cars.CarPresets;
import net.stormdev.ucarstrade.cars.DrivenCar;
import net.stormdev.ucarstrade.protocolMagic.ProtocolManipulator;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitTask;

public class main
extends JavaPlugin {
    public static YamlConfiguration lang = new YamlConfiguration();
    public static main plugin;
    public static FileConfiguration config;
    public static Colors colors;
    public static CustomLogger logger;
    public static ucars ucars;
    public static UTradeCommandExecutor cmdExecutor;
    public static UTradeListener listener;
    public static Random random;
    public CarSaver carSaver = null;
    public CarCalculations carCals = null;
    public ShapedRecipe carRecipe = null;
    public Boolean mariokartInstalled = false;
    public Boolean uCarsRaceInstalled = false;
    public IconMenu tradeMenu = null;
    public SalesManager salesManager = null;
    public static Economy economy;
    public HashMap<String, String> alerts = new HashMap();
    File alertsFile = null;
    public AISpawnManager aiSpawns = null;
    public AIRouter aiController = null;
    public CarShop carShop = null;
    public BukkitTask lagReducer = null;
    public int carCache = 20;
    public SpawnMethod aiSpawnMethod = SpawnMethod.WORLD_PROBE;
    public RouteMethod aiRouteMethod = RouteMethod.ORE;
    public boolean checkSpawnSafety = false;
    public ProtocolManipulator protocolManipulator;

    public boolean setupEconomy() {
        RegisteredServiceProvider economyProvider = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (economyProvider != null) {
            economy = (Economy)economyProvider.getProvider();
        }
        return economy != null;
    }

    public void onEnable() {
        block87: {
            try {
                if (!(Double.parseDouble(com.useful.ucars.ucars.plugin.getDescription().getVersion()) < 17.0)) break block87;
                this.getLogger().log(Level.SEVERE, "uCarsTrade needs uCars v17 or newer to function with the new API!(Installed version: " + com.useful.ucars.ucars.plugin.getDescription().getVersion() + ")");
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.getServer().getPluginManager().disablePlugin((Plugin)this);
                return;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        plugin = this;
        this.getDataFolder().mkdirs();
        File langFile = new File(this.getDataFolder().getAbsolutePath() + File.separator + "lang.yml");
        if (!langFile.exists() || langFile.length() < 1L) {
            try {
                langFile.createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            lang.load(langFile);
            if (!lang.contains("general.place.msg")) {
                lang.set("general.place.msg", (Object)"Placed car %name%, cars can be driven with similar controls to a horse! Change driving mode with jump!");
            }
            if (!lang.contains("general.noExit.msg")) {
                lang.set("general.noExit.msg", (Object)"You may only exit in a clear area!");
            }
            if (!lang.contains("general.sell.msg")) {
                lang.set("general.sell.msg", (Object)"Selling %item% for %price% on the market!");
            }
            if (!lang.contains("general.buy.notEnoughMoney")) {
                lang.set("general.buy.notEnoughMoney", (Object)"You cannot afford that item! You only have %balance%!");
            }
            if (!lang.contains("general.steal.taken")) {
                lang.set("general.steal.taken", (Object)"Car stolen, watch out for the cops!");
            }
            if (!lang.contains("general.buy.taken")) {
                lang.set("general.buy.taken", (Object)"Sorry, somebody else just bought that item.");
            }
            if (!lang.contains("general.buy.success")) {
                lang.set("general.buy.success", (Object)"Successfully bought %item% for %price%, you now have %balance%!");
            }
            if (!lang.contains("general.upgrade.msg")) {
                lang.set("general.upgrade.msg", (Object)"&a+%amount% &e%stat%. Value: %value%");
            }
            if (!lang.contains("general.cmd.playersOnly")) {
                lang.set("general.cmd.playersOnly", (Object)"Players Only!");
            }
            if (!lang.contains("general.cmd.give")) {
                lang.set("general.cmd.give", (Object)"Given you a car!");
            }
            if (!lang.contains("general.hovercar.heightLimit")) {
                lang.set("general.hovercar.heightLimit", (Object)"You may not hover beyond this height!");
            }
            if (!lang.contains("title.carTrading")) {
                lang.set("title.carTrading", (Object)"Car Trading");
            }
            if (!lang.contains("title.trade.buyCars")) {
                lang.set("title.trade.buyCars", (Object)"Buy Cars");
            }
            if (!lang.contains("title.trade.buyUpgrades")) {
                lang.set("title.trade.buyUpgrades", (Object)"Buy Upgrades");
            }
            if (!lang.contains("title.trade.sellCars")) {
                lang.set("title.trade.sellCars", (Object)"Sell a car");
            }
            if (!lang.contains("title.trade.sellUpgrades")) {
                lang.set("title.trade.sellUpgrades", (Object)"Sell Upgrades");
            }
        }
        catch (Exception e1) {
            this.getLogger().log(Level.WARNING, "Error creating/loading lang file! Regenerating..");
        }
        if (!new File(this.getDataFolder().getAbsolutePath() + File.separator + "config.yml").exists() || new File(this.getDataFolder().getAbsolutePath() + File.separator + "config.yml").length() < 1L) {
            this.getDataFolder().mkdirs();
            File configFile = new File(this.getDataFolder().getAbsolutePath() + File.separator + "config.yml");
            try {
                configFile.createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.copy(this.getResource("ucarsTradeConfigHeader.yml"), configFile);
        }
        config = this.getConfig();
        logger = new CustomLogger(this.getServer().getConsoleSender(), this.getLogger());
        try {
            if (!config.contains("general.logger.colour")) {
                config.set("general.logger.colour", (Object)true);
            }
            if (!config.contains("general.cars.names")) {
                ArrayList<String> names = new ArrayList<String>();
                names.add("Car");
                names.add("Peugot");
                names.add("Ferrari");
                names.add("Lotus");
                names.add("Pagani");
                names.add("SmartCar");
                names.add("Maclaren");
                names.add("PimpMobile");
                names.add("SwagMobile");
                names.add("Ford");
                names.add("Koinsegg");
                names.add("ArielAtom");
                names.add("TravelWagon");
                names.add("GeneralMotor");
                names.add("ValueCar");
                config.set("general.cars.names", names);
            }
            if (!config.contains("general.car.damage")) {
                config.set("general.car.damage", (Object)true);
            }
            if (!config.contains("general.car.safeExit")) {
                config.set("general.car.safeExit", (Object)true);
            }
            if (!config.contains("general.car.cache")) {
                config.set("general.car.cache", (Object)100);
            }
            if (!config.contains("general.car.displayInInvAsDisplayBlockWhenExist")) {
                config.set("general.car.displayInInvAsDisplayBlockWhenExist", (Object)true);
            }
            if (!config.contains("general.carTrading.enable")) {
                config.set("general.carTrading.enable", (Object)true);
            }
            if (!config.contains("general.carTrading.currencySign")) {
                config.set("general.carTrading.currencySign", (Object)"$");
            }
            if (!config.contains("general.carTrading.averageCarValue")) {
                config.set("general.carTrading.averageCarValue", (Object)29.99);
            }
            if (!config.contains("general.carTrading.upgradeValue")) {
                config.set("general.carTrading.upgradeValue", (Object)5.0);
            }
            if (!config.contains("general.carTrading.VATPercent")) {
                config.set("general.carTrading.VATPercent", (Object)12.5);
            }
            if (!config.contains("general.hoverCar.heightLimit")) {
                config.set("general.hoverCar.heightLimit", (Object)256.0);
            }
            if (!config.contains("general.ai.enable")) {
                config.set("general.ai.enable", (Object)false);
            }
            if (!config.contains("general.ai.routing")) {
                config.set("general.ai.routing", (Object)RouteMethod.ORE.name());
            } else {
                this.aiRouteMethod = RouteMethod.valueOf(config.getString("general.ai.routing"));
            }
            if (!config.contains("general.ai.trackerBlock.a")) {
                config.set("general.ai.trackerBlock.a", (Object)"DIAMOND_ORE");
            }
            if (!config.contains("general.ai.trackerBlock.b")) {
                config.set("general.ai.trackerBlock.b", (Object)"EMERALD_ORE");
            }
            if (!config.contains("general.ai.trackerBlock.c")) {
                config.set("general.ai.trackerBlock.c", (Object)"REDSTONE_ORE");
            }
            if (!config.contains("general.ai.trackerBlock.d")) {
                config.set("general.ai.trackerBlock.d", (Object)"GOLD_ORE");
            }
            if (!config.contains("general.ai.trackerBlock.pattern")) {
                config.set("general.ai.trackerBlock.pattern", (Object)"a,b,c,d");
            }
            if (!config.contains("general.ai.roadEdgeBlock")) {
                config.set("general.ai.roadEdgeBlock", (Object)"IRON_ORE");
            }
            if (!config.contains("general.ai.junctionBlock")) {
                config.set("general.ai.junctionBlock", (Object)"COAL_ORE");
            }
            if (!config.contains("general.ai.names")) {
                config.set("general.ai.names", (Object)new String[]{"Jeff", "Bob", "Todd", "Jimmy", "Peter", "Fred"});
            }
            if (!config.contains("general.ai.limit")) {
                config.set("general.ai.limit", (Object)69);
            }
            if (!config.contains("general.ai.spawnMethod")) {
                config.set("general.ai.spawnMethod", (Object)SpawnMethod.WORLD_PROBE.name());
            }
            if (!config.contains("general.ai.checkSpawnSafety")) {
                config.set("general.ai.checkSpawnSafety", (Object)this.checkSpawnSafety);
            } else {
                this.checkSpawnSafety = config.getBoolean("general.ai.checkSpawnSafety");
            }
            if (!config.contains("general.ai.canSteal")) {
                config.set("general.ai.canSteal", (Object)true);
            }
            if (!config.contains("colorScheme.success")) {
                config.set("colorScheme.success", (Object)"&a");
            }
            if (!config.contains("colorScheme.error")) {
                config.set("colorScheme.error", (Object)"&c");
            }
            if (!config.contains("colorScheme.info")) {
                config.set("colorScheme.info", (Object)"&e");
            }
            if (!config.contains("colorScheme.title")) {
                config.set("colorScheme.title", (Object)"&9");
            }
            if (!config.contains("colorScheme.tp")) {
                config.set("colorScheme.tp", (Object)"&5");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.carCache = config.getInt("general.car.cache");
        colors = new Colors(config.getString("colorScheme.success"), config.getString("colorScheme.error"), config.getString("colorScheme.info"), config.getString("colorScheme.title"), config.getString("colorScheme.title"));
        CarPresets.init(config);
        logger.info("Config loaded!");
        this.saveConfig();
        try {
            lang.save(langFile);
        }
        catch (IOException e1) {
            this.getLogger().info("Error parsing lang file!");
        }
        this.alertsFile = new File(this.getDataFolder().getAbsolutePath() + File.separator + "alerts.stringMap");
        this.alertsFile.getParentFile().mkdirs();
        if (this.alertsFile.length() < 1L || !this.alertsFile.exists()) {
            try {
                this.alertsFile.createNewFile();
            }
            catch (IOException e) {
                logger.info(colors.getError() + "Failed to create Alerts File");
            }
        }
        logger.info("Searching for uCars...");
        Plugin[] plugins = this.getServer().getPluginManager().getPlugins();
        Boolean installed = false;
        for (Plugin p : plugins) {
            if (!p.getName().equals("uCars")) continue;
            installed = true;
            ucars = (ucars)p;
            CartOrientationUtil.setCartOrientationUtilOverride((CartOrientationUtil.CartOrientationUtilOverride)new OverridenCartOrientationUtil());
        }
        if (!installed.booleanValue()) {
            logger.info("Unable to find uCars!");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
        }
        ucars.hookPlugin((Plugin)this);
        uCarsAPI.getAPI().setuCarsHandlesPlacingCars(false);
        com.useful.ucars.ucars.plugin.ucarsTrade = true;
        logger.info("uCars found and hooked!");
        PluginDescriptionFile pldesc = plugin.getDescription();
        Map commands = pldesc.getCommands();
        Set keys = commands.keySet();
        cmdExecutor = new UTradeCommandExecutor(this);
        for (String k : keys) {
            try {
                this.getCommand(k).setExecutor((CommandExecutor)cmdExecutor);
            }
            catch (Exception e) {
                this.getLogger().log(Level.SEVERE, "Error registering command " + k.toString());
                e.printStackTrace();
            }
        }
        listener = new UTradeListener(this);
        this.getServer().getPluginManager().registerEvents((Listener)listener, (Plugin)this);
        ItemStack car = new ItemStack(Material.MINECART);
        car.setDurability((short)20);
        car = ItemRename.rename(car, "Car");
        this.carRecipe = new ShapedRecipe(car);
        this.carRecipe.shape(new String[]{"012", "345", "678"});
        this.carRecipe.setIngredient('0', Material.REDSTONE);
        this.carRecipe.setIngredient('1', Material.LEVER);
        this.carRecipe.setIngredient('2', Material.REDSTONE);
        this.carRecipe.setIngredient('3', Material.IRON_INGOT);
        this.carRecipe.setIngredient('4', Material.REDSTONE);
        this.carRecipe.setIngredient('5', Material.IRON_INGOT);
        this.carRecipe.setIngredient('6', Material.IRON_INGOT);
        this.carRecipe.setIngredient('7', Material.IRON_INGOT);
        this.carRecipe.setIngredient('8', Material.IRON_INGOT);
        this.getServer().addRecipe((Recipe)this.carRecipe);
        File carSaveFile = new File(this.getDataFolder() + File.separator + "cardata.cache");
        if (carSaveFile.length() < 1L || !carSaveFile.exists()) {
            try {
                carSaveFile.getParentFile().mkdirs();
                carSaveFile.createNewFile();
            }
            catch (IOException e) {
                logger.info(colors.getError() + "Failed to create new car data file!");
            }
        }
        this.carSaver = new CarSaver(carSaveFile);
        this.carSaver.load();
        this.carCals = new CarCalculations();
        if (this.getServer().getPluginManager().getPlugin("uCarsRace") != null) {
            this.uCarsRaceInstalled = true;
        }
        if (this.getServer().getPluginManager().getPlugin("MarioKart") != null) {
            this.mariokartInstalled = true;
        }
        this.tradeMenu = new IconMenu(colors.getTitle() + Lang.get("title.carTrading"), 9, new IconMenu.OptionClickEventHandler(){

            @Override
            public void onOptionClick(IconMenu.OptionClickEvent event) {
                event.setWillClose(true);
                TradeBoothClickEvent evt = new TradeBoothClickEvent(event, TradeBoothMenuType.MENU, 1);
                plugin.getServer().getPluginManager().callEvent((Event)evt);
            }
        }, (Plugin)plugin);
        this.tradeMenu.setOption(0, new ItemStack(Material.BOOK, 1), colors.getTitle() + "Read Tutorial", colors.getInfo() + "Read the tutorial!");
        this.tradeMenu.setOption(1, new ItemStack(Material.MINECART, 1), colors.getTitle() + "Buy Cars", colors.getInfo() + "Buy Cars!");
        this.tradeMenu.setOption(2, new ItemStack(Material.MINECART, 1), colors.getTitle() + "Sell Cars", colors.getInfo() + "Sell cars!");
        this.tradeMenu.setOption(3, new ItemStack(Material.IRON_INGOT, 1), colors.getTitle() + "Buy Upgrades", colors.getInfo() + "Buy upgrades for your cars!");
        this.tradeMenu.setOption(4, new ItemStack(Material.IRON_INGOT, 1), colors.getTitle() + "Sell Upgrades", colors.getInfo() + "Sell upgrades for cars!");
        this.carShop = new CarShop(this);
        uCarsAPI.getAPI().registerItemCarCheck((Plugin)this, new ItemCarCheck(){

            public Boolean isACar(ItemStack item) {
                return ItemCarValidation.getCar(item) != null;
            }
        });
        File carsMarketSaveFile = new File(this.getDataFolder().getAbsolutePath() + File.separator + "carsMarket.marketData");
        File upgradesMarketSaveFile = new File(this.getDataFolder().getAbsolutePath() + File.separator + "upgradesMarket.marketData");
        this.salesManager = new SalesManager(carsMarketSaveFile, upgradesMarketSaveFile);
        if (config.getBoolean("general.carTrading.enable") && !this.setupEconomy()) {
            logger.info("Economy plugin not found on startup. An economy plugin and vault are neededfor trade features. If one is successfully installed then don't worry. We'll find it later.");
        }
        this.alerts = main.loadHashMapAlerts(this.alertsFile.getAbsolutePath());
        if (this.alerts == null) {
            this.alerts = new HashMap();
        }
        if (config.getBoolean("general.ai.enable")) {
            String spawnMethodRaw = config.getString("general.ai.spawnMethod");
            try {
                SpawnMethod method = SpawnMethod.valueOf(spawnMethodRaw);
                if (method == null) {
                    throw new Exception();
                }
                this.aiSpawnMethod = method;
            }
            catch (Exception e) {
                this.getLogger().info("INVALID AI spawn method set, it must be either 'WORLD_PROBE' or 'NODES'");
            }
        }
        if (this.aiSpawnMethod.equals((Object)SpawnMethod.WORLD_PROBE)) {
            this.aiSpawns = new AIWorldProbingSpawnManager(this, config.getBoolean("general.ai.enable"));
        } else if (this.aiSpawnMethod.equals((Object)SpawnMethod.NODES)) {
            this.initNodeAISpawnManager();
        }
        this.aiController = new AIRouter(config.getBoolean("general.ai.enable"));
        new IconMenuListener();
        this.protocolManipulator = new ProtocolManipulator(ProtocolLibrary.getProtocolManager());
        this.protocolManipulator.registerManipulations();
        logger.info("uCarsTrade v" + plugin.getDescription().getVersion() + " has been enabled!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDisable() {
        try {
            if (this.alertsFile.length() < 1L || !this.alertsFile.exists()) {
                try {
                    this.alertsFile.createNewFile();
                }
                catch (IOException e) {
                    logger.info(colors.getError() + "Failed to create Alerts File");
                }
            }
            main.saveHashMapAlerts(this.alerts, this.alertsFile.getAbsolutePath());
            if (ucars != null) {
                ucars.unHookPlugin((Plugin)this);
            }
            this.aiSpawns.shutdown();
            for (World w : Bukkit.getWorlds()) {
                for (Entity e : new ArrayList(w.getEntities())) {
                    try {
                        DrivenCar c;
                        if (!UEntityMeta.hasMetadata((Entity)e, (String)"trade.npc") || !(e instanceof Vehicle) || (c = main.plugin.carSaver.getCarInUse((Entity)((Vehicle)e))) == null || !c.isNPC()) continue;
                        AIRouter.despawnNPCCarNow((Entity)((Vehicle)e), c);
                        e.remove();
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
            }
            this.carShop.destroy();
            Bukkit.getScheduler().cancelTasks((Plugin)this);
            logger.info("uCarsTrade has been disabled!");
        }
        catch (Exception exception) {
        }
        finally {
            this.getLogger().info("Disabled uCarsTrade!");
        }
    }

    private void copy(InputStream in, File file) {
        try {
            int len;
            FileOutputStream out = new FileOutputStream(file);
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((OutputStream)out).close();
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String colorise(String prefix) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)prefix);
    }

    public static HashMap<String, String> loadHashMapAlerts(String path) {
        try {
            ObjectInputStream ois = new ObjectInputStream(new FileInputStream(path));
            Object result = ois.readObject();
            ois.close();
            return (HashMap)result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void saveHashMapAlerts(HashMap<String, String> map, String path) {
        try {
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(path));
            oos.writeObject(map);
            oos.flush();
            oos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void initNodeAISpawnManager() {
        this.aiSpawns = new AINodesSpawnManager(this, config.getBoolean("general.ai.enable"), new File(this.getDataFolder() + File.separator + "aiSpawnNodes.nodelist"));
    }

    static {
        config = new YamlConfiguration();
        logger = null;
        ucars = null;
        cmdExecutor = null;
        listener = null;
        random = new Random();
        economy = null;
    }
}

