/*
 * Decompiled with CFR 0.152.
 */
package net.stormdev.ucars.trade.AIVehicles.spawning.nodes;

import com.google.common.io.Files;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import net.stormdev.ucars.trade.AIVehicles.spawning.nodes.ChunkCoord;
import net.stormdev.ucars.trade.AIVehicles.spawning.nodes.Node;
import net.stormdev.ucars.trade.main;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;

public class NodesStore {
    private Map<ChunkCoord, List<Node>> nodesByActiveChunks = new HashMap<ChunkCoord, List<Node>>();
    private File saveFile = null;
    public static boolean beingModified = false;

    public NodesStore(File saveFile) {
        this.saveFile = saveFile;
        this.load();
    }

    public List<Node> getAllNodes() {
        ArrayList<Node> results = new ArrayList<Node>();
        for (List<Node> nodes : this.nodesByActiveChunks.values()) {
            results.addAll(nodes);
        }
        return Collections.unmodifiableList(results);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNodeCount() {
        if (beingModified) {
            NodesStore nodesStore = this;
            synchronized (nodesStore) {
                return this.nodeCount();
            }
        }
        return this.nodeCount();
    }

    private int nodeCount() {
        ArrayList<Node> counted = new ArrayList<Node>();
        for (ChunkCoord chunkCoord : new ArrayList<ChunkCoord>(this.nodesByActiveChunks.keySet())) {
            List<Node> nodes = this.nodesByActiveChunks.get(chunkCoord);
            for (Node n : nodes) {
                boolean alreadyCounted = false;
                for (Node countedNode : counted) {
                    if (!n.equals(countedNode)) continue;
                    alreadyCounted = true;
                    break;
                }
                if (alreadyCounted) continue;
                counted.add(n);
            }
        }
        return counted.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNode(Node node) {
        if (beingModified) {
            NodesStore nodesStore = this;
            synchronized (nodesStore) {
                this.removeANode(node);
                return;
            }
        }
        this.removeANode(node);
    }

    private void removeANode(Node node) {
        for (ChunkCoord key : new ArrayList<ChunkCoord>(this.nodesByActiveChunks.keySet())) {
            List<Node> nodes = this.nodesByActiveChunks.get(key);
            if (node == null || !nodes.contains(node)) continue;
            nodes.remove(node);
        }
        this.asyncSave();
    }

    public void revalidateNodes() {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)main.plugin, new Runnable(){

            @Override
            public void run() {
                NodesStore.this.revalidateNodesNow();
            }
        });
    }

    public synchronized void resetNodes() {
        File backup = new File(this.saveFile.getParentFile() + File.separator + "oldNodes.nodelist");
        if (!backup.exists()) {
            backup.getParentFile().mkdirs();
            try {
                backup.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            if (this.saveFile.exists()) {
                Files.copy((File)this.saveFile, (File)backup);
                this.saveFile.delete();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.nodesByActiveChunks.clear();
        this.asyncSave();
    }

    public void revalidateNodesNow() {
        main.plugin.getLogger().info("Revalidating ALL AI spawn nodes; this could take some time!");
        int nodesRemoved = 0;
        for (ChunkCoord coord : new ArrayList<ChunkCoord>(this.nodesByActiveChunks.keySet())) {
            List<Node> chunkNodes = this.nodesByActiveChunks.get(coord);
            for (final Node n : new ArrayList<Node>(chunkNodes)) {
                boolean valid = true;
                if (!Bukkit.isPrimaryThread()) {
                    Future isValid = Bukkit.getScheduler().callSyncMethod((Plugin)main.plugin, (Callable)new Callable<Boolean>(){

                        @Override
                        public Boolean call() throws Exception {
                            return n.isValid();
                        }
                    });
                    try {
                        valid = (Boolean)isValid.get();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    valid = n.isValid();
                }
                if (valid) continue;
                ++nodesRemoved;
                chunkNodes.remove(n);
            }
            this.nodesByActiveChunks.put(coord, chunkNodes);
            Thread.yield();
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (nodesRemoved > 0) {
            this.saveNow();
        }
        main.plugin.getLogger().info("Successfully revalidated all AI spawn nodes - " + nodesRemoved + " invalid nodes were purged!");
    }

    public Node getRandomActiveNode(Entity entity, float minDistance, float maxDistance) {
        return this.getRandomActiveNode(entity.getLocation(), minDistance, maxDistance);
    }

    public Node getRandomActiveNode(Location location, float minDistance, float maxDistance) {
        List<Node> avail = this.getActiveNodes(location, minDistance, maxDistance);
        if (avail.size() < 1) {
            return null;
        }
        return avail.get(main.random.nextInt(avail.size()));
    }

    public List<Node> getActiveNodes(Entity entity, float minDistance, float maxDistance) {
        return this.getActiveNodes(entity.getLocation(), minDistance, maxDistance);
    }

    public List<Node> getActiveNodes(Location location, float minDistance, float maxDistance) {
        List<Node> active = this.getActiveNodes(location);
        ArrayList<Node> res = new ArrayList<Node>();
        double minSquared = Math.pow(minDistance, 2.0);
        double maxSquared = Math.pow(maxDistance, 2.0);
        for (Node n : active) {
            double distanceSquared;
            Location nl = n.getLocation();
            if (!nl.getWorld().equals(location.getWorld()) || !((distanceSquared = nl.distanceSquared(location)) < maxSquared) || !(distanceSquared > minSquared)) continue;
            res.add(n);
        }
        return res;
    }

    public List<Node> getActiveNodes(Entity entity) {
        return this.getActiveNodes(entity.getLocation());
    }

    public List<Node> getActiveNodes(Location location) {
        int cx = location.getBlockX() >> 4;
        int cz = location.getBlockZ() >> 4;
        ChunkCoord cord = new ChunkCoord(location.getWorld(), cx, cz);
        List<Node> res = this.getActiveNodes(cord);
        if (res == null) {
            return new ArrayList<Node>();
        }
        return res;
    }

    public List<Node> getActiveNodes(Chunk chunk) {
        return this.getActiveNodes(new ChunkCoord(chunk));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Node> getActiveNodes(ChunkCoord coord) {
        if (beingModified) {
            NodesStore nodesStore = this;
            synchronized (nodesStore) {
                return this.getChunkActiveNodes(coord);
            }
        }
        return this.getChunkActiveNodes(coord);
    }

    private List<Node> getChunkActiveNodes(ChunkCoord coord) {
        List<Node> chunkNodes = this.nodesByActiveChunks.get(coord);
        return chunkNodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setNodeIntoCorrectActiveChunks(final Node node) {
        beingModified = true;
        try {
            Chunk nodeChunk = null;
            World nodeWorld = null;
            if (Bukkit.isPrimaryThread()) {
                nodeChunk = node.getChunk();
                nodeWorld = nodeChunk.getWorld();
            } else {
                try {
                    Future getChunk = Bukkit.getScheduler().callSyncMethod((Plugin)main.plugin, (Callable)new Callable<Chunk>(){

                        @Override
                        public Chunk call() {
                            return node.getChunk();
                        }
                    });
                    final Chunk nc = nodeChunk = (Chunk)getChunk.get();
                    Future getWorld = Bukkit.getScheduler().callSyncMethod((Plugin)main.plugin, (Callable)new Callable<World>(){

                        @Override
                        public World call() {
                            return nc.getWorld();
                        }
                    });
                    nodeWorld = (World)getWorld.get();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            int chunkX = nodeChunk.getX();
            int chunkZ = nodeChunk.getZ();
            for (int x = chunkX - 6; x <= chunkX + 7; ++x) {
                for (int z = chunkZ - 6; z <= chunkZ + 7; ++z) {
                    ChunkCoord coord = new ChunkCoord(nodeWorld, x, z);
                    List<Object> chunkNodes = new ArrayList();
                    for (ChunkCoord key : new ArrayList<ChunkCoord>(this.nodesByActiveChunks.keySet())) {
                        if (!key.isEqualTo(coord)) continue;
                        chunkNodes = this.nodesByActiveChunks.get(key);
                    }
                    boolean alreadySet = false;
                    for (Node n : new ArrayList(chunkNodes)) {
                        if (!n.isEqualTo(node)) continue;
                        if (n.equals(node)) {
                            alreadySet = true;
                            break;
                        }
                        chunkNodes.remove(n);
                    }
                    if (alreadySet) continue;
                    chunkNodes.add(node);
                    this.nodesByActiveChunks.put(coord, chunkNodes);
                }
            }
        }
        finally {
            beingModified = false;
        }
    }

    public synchronized void saveNow() {
        try {
            if (!this.saveFile.exists()) {
                this.saveFile.getParentFile().mkdirs();
                this.saveFile.createNewFile();
            }
            try (ObjectOutputStream oos = new ObjectOutputStream(new DataOutputStream(new FileOutputStream(this.saveFile)));){
                oos.writeObject(this.nodesByActiveChunks);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void asyncSave() {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)main.plugin, new Runnable(){

            @Override
            public void run() {
                NodesStore.this.saveNow();
            }
        });
    }

    public synchronized void load() {
        main.plugin.getLogger().info("Loading existing AI spawn nodes...");
        if (!this.saveFile.exists() || this.saveFile.length() < 1L) {
            return;
        }
        try (ObjectInputStream ois2 = new ObjectInputStream(new DataInputStream(new FileInputStream(this.saveFile)));){
            Object in = ois2.readObject();
            if (in != null && in instanceof Map) {
                this.nodesByActiveChunks = (Map)in;
            }
        }
        catch (FileNotFoundException ois2) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        main.plugin.getLogger().info("Nodes loaded!");
    }
}

