/*
 * Decompiled with CFR 0.152.
 */
package net.stormdev.uPlanes.main;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.stormdev.uPlanes.api.Boat;
import net.stormdev.uPlanes.items.ItemBoatValidation;
import net.stormdev.uPlanes.main.main;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class BoatsManager {
    private ConcurrentHashMap<UUID, Boat> boats = new ConcurrentHashMap();
    public ConcurrentHashMap<UUID, Boat> cache = new ConcurrentHashMap();
    File saveFile = null;

    public BoatsManager(File saveFile) {
        this.saveFile = saveFile;
        this.load();
        Bukkit.getScheduler().runTaskTimer((Plugin)main.plugin, new Runnable(){

            @Override
            public void run() {
                final ArrayList entities = new ArrayList();
                for (World w : Bukkit.getWorlds()) {
                    entities.addAll(w.getEntities());
                }
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)main.plugin, new Runnable(){

                    @Override
                    public void run() {
                        block0: for (UUID id : new ArrayList(BoatsManager.this.boats.keySet())) {
                            for (Entity e : entities) {
                                if (!e.getUniqueId().equals(id)) continue;
                                continue block0;
                            }
                            BoatsManager.this.boats.remove(id);
                            BoatsManager.this.cache.remove(id);
                        }
                    }
                });
            }
        }, 5200L, 5200L);
    }

    public Boolean isBoatInUse(UUID PlaneId) {
        if (this.cache.containsKey(PlaneId)) {
            return true;
        }
        Boolean b = this.boats.containsKey(PlaneId);
        if (b.booleanValue()) {
            this.cache.put(PlaneId, this.boats.get(PlaneId));
            this.cacheSize();
        }
        return b;
    }

    public Boolean isBoatInUse(Boat plane) {
        UUID PlaneId = plane.getId();
        if (this.cache.containsKey(PlaneId)) {
            return true;
        }
        Boolean b = this.boats.containsKey(PlaneId);
        if (b.booleanValue()) {
            this.cache.put(PlaneId, this.boats.get(PlaneId));
            this.cacheSize();
        }
        return b;
    }

    public Boat getBoat(ItemStack item) {
        return ItemBoatValidation.getBoat(item);
    }

    public Boolean isABoat(ItemStack item) {
        return this.getBoat(item) != null;
    }

    public Boat getBoat(UUID PlaneId) {
        Boat c = this.cache.get(PlaneId);
        if (c != null) {
            return c;
        }
        return this.boats.get(PlaneId);
    }

    public void cacheSize() {
        while (this.cache.size() > main.plugin.cacheSize) {
            this.cache.remove(((ConcurrentHashMap.CollectionView)((Object)this.cache.keySet())).toArray()[0]);
        }
    }

    public void removeFromCache(UUID PlaneId) {
        this.cache.remove(PlaneId);
    }

    public void noLongerPlaced(UUID PlaneId) {
        this.cache.remove(PlaneId);
        this.boats.remove(PlaneId);
        this.asyncSave();
    }

    public void nowPlaced(Boat Plane2) {
        UUID PlaneId = Plane2.getId();
        this.cache.put(PlaneId, Plane2);
        this.boats.put(PlaneId, Plane2);
        this.cacheSize();
        this.asyncSave();
    }

    public void updateUsedBoat(UUID old, Boat current) {
        this.noLongerPlaced(old);
        this.nowPlaced(current);
        this.asyncSave();
    }

    public void asyncSave() {
        main.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)main.plugin, new BukkitRunnable(){

            public void run() {
                BoatsManager.this.save();
            }
        });
    }

    public void load() {
        this.saveFile.getParentFile().mkdirs();
        if (!this.saveFile.exists() || this.saveFile.length() < 1L) {
            try {
                this.saveFile.createNewFile();
            }
            catch (IOException iOException) {}
        } else {
            try {
                this.boats = BoatsManager.loadHashMap(this.saveFile.getAbsolutePath());
            }
            catch (Exception e) {
                this.boats = null;
            }
        }
        if (this.boats == null) {
            this.boats = new ConcurrentHashMap();
            this.save();
        }
    }

    private void save() {
        this.saveFile.getParentFile().mkdirs();
        if (!this.saveFile.exists() || this.saveFile.length() < 1L) {
            try {
                this.saveFile.createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        BoatsManager.saveHashMap(this.boats, this.saveFile.getAbsolutePath());
    }

    public static void saveHashMap(ConcurrentHashMap<UUID, Boat> map, String path) {
        try {
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(path));
            oos.writeObject(map);
            oos.flush();
            oos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static ConcurrentHashMap<UUID, Boat> loadHashMap(String path) {
        try {
            ObjectInputStream ois = new ObjectInputStream(new FileInputStream(path));
            Object result = ois.readObject();
            ois.close();
            try {
                return (ConcurrentHashMap)result;
            }
            catch (Exception e) {
                return new ConcurrentHashMap<UUID, Boat>();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

