/*
 * Decompiled with CFR 0.152.
 */
package net.stormdev.uPlanes.api;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.regex.Pattern;
import net.stormdev.uPlanes.api.AccelerationModifier;
import net.stormdev.uPlanes.api.Plane;
import net.stormdev.uPlanes.api.PlaneDamageEvent;
import net.stormdev.uPlanes.api.PlaneDeathEvent;
import net.stormdev.uPlanes.api.PlaneTurningModifier;
import net.stormdev.uPlanes.hover.HoverCart;
import net.stormdev.uPlanes.hover.HoverCartEntity;
import net.stormdev.uPlanes.items.ItemPlaneValidation;
import net.stormdev.uPlanes.main.PlaneGenerator;
import net.stormdev.uPlanes.main.PlaneItemMethods;
import net.stormdev.uPlanes.main.main;
import net.stormdev.uPlanes.presets.PlanePreset;
import net.stormdev.uPlanes.utils.CartOrientationUtil;
import net.stormdev.uPlanes.utils.Lang;
import net.stormdev.uPlanes.utils.PEntityMeta;
import net.stormdev.uPlanes.utils.StatValue;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.MaterialData;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class uPlaneManager {
    private volatile List<AccelerationModifier> accelMods = new ArrayList<AccelerationModifier>();
    private volatile List<AccelerationModifier> decelMods = new ArrayList<AccelerationModifier>();
    private volatile List<PlaneTurningModifier> rotMods = new ArrayList<PlaneTurningModifier>();

    protected uPlaneManager() {
    }

    public void addTurningModifier(PlaneTurningModifier mod) {
        this.rotMods.add(mod);
    }

    public void removeTurningModifier(PlaneTurningModifier mod) {
        this.rotMods.remove(mod);
    }

    public double getAlteredRotationAmountPerTick(Player player, Vehicle cart, Plane plane) {
        double current = plane.getTurnAmountPerTick();
        for (PlaneTurningModifier am : new ArrayList<PlaneTurningModifier>(this.rotMods)) {
            current *= am.getTurnAmountPerTick(cart, current);
        }
        return current;
    }

    public void addAccelerationModifier(AccelerationModifier mod) {
        this.accelMods.add(mod);
    }

    public void removeAccelerationModifier(AccelerationModifier mod) {
        this.accelMods.remove(mod);
    }

    public void addDecelerationModifier(AccelerationModifier mod) {
        this.decelMods.add(mod);
    }

    public void removeDecelerationModifier(AccelerationModifier mod) {
        this.decelMods.remove(mod);
    }

    public double getAlteredDecelerationMod(Player player, Vehicle cart, Plane plane) {
        double current = 1.0;
        for (AccelerationModifier am : new ArrayList<AccelerationModifier>(this.decelMods)) {
            current *= am.getAccelerationMultiplier(player, cart, plane);
        }
        return current;
    }

    public double getAlteredAccelerationMod(Player player, Vehicle cart, Plane plane) {
        double current = 1.0;
        for (AccelerationModifier am : new ArrayList<AccelerationModifier>(this.accelMods)) {
            try {
                current *= am.getAccelerationMultiplier(player, cart, plane);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return current;
    }

    public Plane generateRandomPlane() {
        Plane plane = PlaneGenerator.gen();
        return plane;
    }

    public Plane generateRandomPlane(boolean hover) {
        Plane plane = PlaneGenerator.gen();
        if (hover) {
            plane.setName("Hover Plane");
            plane.setHover(true);
        }
        return plane;
    }

    public Plane generatePlane(double health, double speed, String name, boolean hover) {
        Plane plane = PlaneGenerator.gen();
        plane.setId(UUID.randomUUID());
        plane.setHealth(health);
        plane.setSpeed(speed);
        plane.setName(name);
        if (hover) {
            plane.setHover(true);
        }
        return plane;
    }

    @Deprecated
    public void saveOrUpdatePlane(Plane plane) {
        main.plugin.planeManager.updateUsedPlane(plane.getId(), plane);
    }

    public void removePlane(Plane plane) {
        main.plugin.planeManager.noLongerPlaced(plane.getId());
    }

    public void removePlane(UUID planeId) {
        main.plugin.planeManager.noLongerPlaced(planeId);
    }

    public Plane getPlaneById(UUID planeId) {
        return main.plugin.planeManager.getPlane(planeId);
    }

    public ItemStack getPlaneItem(Plane plane) {
        return PlaneItemMethods.getItem(plane);
    }

    public Plane getPlaneFromItem(ItemStack stack) {
        Plane item = ItemPlaneValidation.getPlane(stack);
        return item;
    }

    public boolean isAPlane(UUID entityId) {
        return main.plugin.planeManager.isPlaneInUse(entityId);
    }

    public boolean isAPlane(Entity entity) {
        return this.isAPlane(entity.getUniqueId());
    }

    @Deprecated
    public boolean isPlanePlaced(Plane plane) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vehicle placePlane(Plane plane, Location loc, Vector directionToFace) {
        Class<uPlaneManager> clazz = uPlaneManager.class;
        synchronized (uPlaneManager.class) {
            Vehicle ent;
            PlanePreset pp = plane.getPreset();
            MaterialData display = null;
            double offset = 0.0;
            if (plane.getCartDisplayBlock() != null) {
                display = plane.getCartDisplayBlock();
                offset = plane.getDisplayOffset();
            } else if (pp != null && pp.hasDisplayBlock()) {
                display = pp.getDisplayBlock();
                offset = pp.getDisplayOffset();
            }
            if (display == null) {
                ent = (Vehicle)loc.getWorld().spawnEntity(loc, EntityType.MINECART);
            } else {
                HoverCartEntity hce = new HoverCartEntity(loc.clone().add(0.0, 0.3, 0.0));
                hce.setHitBoxX(plane.getHitboxX());
                hce.setHitBoxZ(plane.getHitboxZ());
                hce.setMaxPassengers(plane.getMaxPassengers());
                hce.setBoatOffsetDeg(plane.getBoatRotationOffsetDegrees());
                HoverCart hc = hce.spawn();
                ent = hc;
                hc.setDisplay(new ItemStack(display.getItemType(), 1, (short)display.getData()), offset);
            }
            PEntityMeta.setMetadata((Entity)ent, "ucars.ignore", new StatValue(true, (Plugin)main.plugin));
            PEntityMeta.setMetadata((Entity)ent, "plane.health", new StatValue(plane.getHealth(), (Plugin)main.plugin));
            if (plane.isHover()) {
                PEntityMeta.setMetadata((Entity)ent, "plane.hover", new StatValue(true, (Plugin)main.plugin));
                plane.setHover(true);
            }
            PEntityMeta.setMetadata((Entity)ent, "plane.direction", new StatValue(directionToFace.clone(), (Plugin)main.plugin));
            plane.setId(ent.getUniqueId());
            plane.setRoll(0.0);
            float vYaw = (float)Math.toDegrees(Math.atan2(directionToFace.getX(), -directionToFace.getZ()));
            CartOrientationUtil.setYaw(ent, vYaw -= 90.0f);
            main.plugin.planeManager.nowPlaced(plane);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return ent;
        }
    }

    public Vehicle placePlane(Plane plane, Location loc) {
        return this.placePlane(plane, loc, loc.getDirection());
    }

    public Vehicle placePlane(Plane plane, Location loc, ItemStack planeStack) {
        planeStack.setAmount(planeStack.getAmount() - 1);
        if (planeStack.getAmount() <= 0) {
            planeStack.setType(Material.AIR);
        }
        return this.placePlane(plane, loc);
    }

    private PlaneDamageEvent planeDamageEvent(Vehicle v, Plane p, double dmg, String cause) {
        PlaneDamageEvent pde = new PlaneDamageEvent(v, p, dmg, cause);
        Bukkit.getPluginManager().callEvent((Event)pde);
        return pde;
    }

    public ItemStack destroyPlane(Vehicle vehicle, Plane plane) {
        UUID id = vehicle.getUniqueId();
        main.plugin.planeManager.noLongerPlaced(id);
        Entity top = vehicle.getPassenger();
        if (top instanceof Player) {
            top.eject();
            top.setVelocity(vehicle.getVelocity());
        }
        vehicle.eject();
        vehicle.remove();
        ItemStack i = plane.toItemStack();
        return i;
    }

    public void damagePlane(Vehicle m, Plane plane, double damage, Player damager, boolean breakIt) {
        if (m.hasMetadata("invincible") || PEntityMeta.hasMetadata((Entity)m, "invincible")) {
            return;
        }
        double health = plane.getHealth();
        if (PEntityMeta.hasMetadata((Entity)m, "plane.health")) {
            List<MetadataValue> ms = PEntityMeta.getMetadata((Entity)m, "plane.health");
            health = (Double)ms.get(0).value();
        }
        String msg = Lang.get("general.damage.msg");
        msg = msg.replaceAll(Pattern.quote("%damage%"), damage + "HP");
        if ((health -= damage) <= 0.0) {
            health = 0.0;
        }
        health = (double)Math.round(health * 10.0) / 10.0;
        msg = msg.replaceAll(Pattern.quote("%remainder%"), health + "HP");
        msg = msg.replaceAll(Pattern.quote("%cause%"), "Fist");
        damager.sendMessage(main.colors.getInfo() + msg);
        this.damagePlane(m, plane, damage, breakIt);
    }

    public void damagePlane(Vehicle m, Plane plane, double damage, Player damager, String cause, boolean breakIt) {
        if (m.hasMetadata("invincible") || PEntityMeta.hasMetadata((Entity)m, "invincible")) {
            return;
        }
        double health = plane.getHealth();
        if (PEntityMeta.hasMetadata((Entity)m, "plane.health")) {
            List<MetadataValue> ms = PEntityMeta.getMetadata((Entity)m, "plane.health");
            health = (Double)ms.get(0).value();
        }
        String msg = Lang.get("general.damage.msg");
        msg = msg.replaceAll(Pattern.quote("%damage%"), damage + "HP");
        if ((health -= damage) <= 0.0) {
            health = 0.0;
        }
        health = (double)Math.round(health * 10.0) / 10.0;
        msg = msg.replaceAll(Pattern.quote("%remainder%"), health + "HP");
        msg = msg.replaceAll(Pattern.quote("%cause%"), cause);
        damager.sendMessage(main.colors.getInfo() + msg);
        this.damagePlane(m, plane, damage, breakIt);
    }

    public void damagePlane(Vehicle m, Plane plane, double damage, Player damager, String cause) {
        this.damagePlane(m, plane, damage, damager, cause, true);
    }

    public void damagePlane(Vehicle m, Plane plane, double damage, Player damager) {
        this.damagePlane(m, plane, damage, damager, true);
    }

    public void damagePlane(Vehicle m, Plane plane, double damage, String cause) {
        this.damagePlane(m, plane, damage, cause, true);
    }

    public void damagePlane(Vehicle m, Plane plane, double damage) {
        this.damagePlane(m, plane, damage, true);
    }

    public void damagePlane(Vehicle m, Plane plane, double damage, String cause, boolean breakIt) {
        if (m.hasMetadata("invincible") || PEntityMeta.hasMetadata((Entity)m, "invincible")) {
            return;
        }
        PlaneDamageEvent evt1 = this.planeDamageEvent(m, plane, damage, cause);
        if (evt1.isCancelled()) {
            return;
        }
        double health = plane.getHealth();
        if (PEntityMeta.hasMetadata((Entity)m, "plane.health")) {
            List<MetadataValue> ms = PEntityMeta.getMetadata((Entity)m, "plane.health");
            health = (Double)ms.get(0).value();
        }
        String msg = Lang.get("general.damage.msg");
        Boolean die = false;
        msg = msg.replaceAll(Pattern.quote("%damage%"), damage + "HP");
        if ((health -= damage) <= 0.0) {
            die = true;
            health = 0.0;
        }
        health = (double)Math.round(health * 10.0) / 10.0;
        msg = msg.replaceAll(Pattern.quote("%remainder%"), health + "HP");
        msg = msg.replaceAll(Pattern.quote("%cause%"), cause);
        if (m.getPassenger() != null && m.getPassenger() instanceof Player) {
            ((Player)m.getPassenger()).sendMessage(main.colors.getInfo() + msg);
        }
        PEntityMeta.removeMetadata((Entity)m, "plane.health");
        PEntityMeta.setMetadata((Entity)m, "plane.health", new StatValue(health, (Plugin)main.plugin));
        if (die.booleanValue() || health < 0.1 && breakIt) {
            PlaneDeathEvent evt = new PlaneDeathEvent(m, plane);
            main.plugin.getServer().getPluginManager().callEvent((Event)evt);
            if (!evt.isCancelled()) {
                main.plugin.listener.killPlane(m, plane);
            }
        }
    }

    public void healPlane(Vehicle m, Plane plane) {
        double health = plane.getHealth();
        PEntityMeta.removeMetadata((Entity)m, "plane.health");
        PEntityMeta.setMetadata((Entity)m, "plane.health", new StatValue(health, (Plugin)main.plugin));
    }

    public void damagePlane(Vehicle m, Plane plane, double damage, boolean breakIt) {
        this.damagePlane(m, plane, damage, "Damage", breakIt);
    }
}

