/*
 * Decompiled with CFR 0.152.
 */
package net.stormdev.uPlanes.guis;

import java.util.List;
import net.stormdev.uPlanes.guis.IconMenu;
import net.stormdev.uPlanes.main.main;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class PagedMenu {
    private final int PAGE_SIZE;
    private Plugin plug;
    private MenuDetails details;

    public PagedMenu(MenuDetails details) {
        this.details = details;
        this.plug = main.plugin;
        this.PAGE_SIZE = details.getPageSize();
        if (this.PAGE_SIZE % 9 != 0 || this.PAGE_SIZE < 1) {
            throw new RuntimeException("Invalid Paged Menu! Page Size MUST be divisible by 9");
        }
    }

    public void open(final Player player) {
        player.sendMessage(ChatColor.GRAY + "Opening...");
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)main.plugin, new Runnable(){

            @Override
            public void run() {
                final List<MenuDetails.MenuItem> items = PagedMenu.this.details.getDisplayItems(player);
                Bukkit.getScheduler().runTaskAsynchronously(PagedMenu.this.plug, new Runnable(){

                    @Override
                    public void run() {
                        PagedMenu.this.createDisplay(player, items, 1);
                    }
                });
            }
        });
    }

    private void createDisplay(Player player, final List<MenuDetails.MenuItem> owned, final int pageNo) {
        if (pageNo < 1) {
            this.createDisplay(player, owned, 1);
            return;
        }
        int page = pageNo - 1;
        final int startPos = (this.PAGE_SIZE - 2) * page;
        int endPos = startPos + (this.PAGE_SIZE - 2);
        if (this.plug == null) {
            Bukkit.broadcastMessage((String)"UH OH MEMORY LEAK ALERT SAFEGUARD #1 PLEASE REPORT");
        }
        final IconMenu menu = new IconMenu(this.details.getColouredMenuTitle(player), this.PAGE_SIZE, new IconMenu.OptionClickEventHandler(){

            @Override
            public void onOptionClick(IconMenu.OptionClickEvent event) {
                MenuDetails.MenuItem c;
                Player player = event.getPlayer();
                event.setWillDestroy(false);
                int i = event.getPosition();
                if (i == PagedMenu.this.PAGE_SIZE - 2) {
                    final int newPage = pageNo - 1;
                    final Player pl = player;
                    Bukkit.getScheduler().runTaskLater(PagedMenu.this.plug, new Runnable(){

                        @Override
                        public void run() {
                            PagedMenu.this.createDisplay(pl, owned, newPage);
                        }
                    }, 2L);
                    event.setWillClose(true);
                    event.setWillDestroy(true);
                    return;
                }
                if (i == PagedMenu.this.PAGE_SIZE - 1) {
                    final int newPage = pageNo + 1;
                    final Player pl = player;
                    Bukkit.getScheduler().runTaskLater(PagedMenu.this.plug, new Runnable(){

                        @Override
                        public void run() {
                            PagedMenu.this.createDisplay(pl, owned, newPage);
                        }
                    }, 2L);
                    event.setWillClose(true);
                    event.setWillDestroy(true);
                    return;
                }
                int listPos = startPos + i;
                try {
                    c = (MenuDetails.MenuItem)owned.get(listPos);
                }
                catch (Exception e) {
                    event.setWillClose(false);
                    return;
                }
                if (c == null) {
                    event.setWillClose(false);
                    return;
                }
                event.setWillClose(true);
                event.setWillDestroy(true);
                c.onClick(player);
            }
        }, this.plug, true);
        int z = 0;
        boolean valid = false;
        for (int i = startPos; i < owned.size() && i < endPos && z < endPos + 1; ++z, ++i) {
            MenuDetails.MenuItem c = owned.get(i);
            ItemStack display = c.getDisplayItem();
            menu.setOption(z, display, c.getColouredTitle(), c.getColouredLore());
            valid = true;
        }
        if (!valid) {
            final int newPage = pageNo - 1;
            if (newPage < 1) {
                player.sendMessage(ChatColor.RED + this.details.noDisplayItemMessage());
                return;
            }
            final Player pl = player;
            Bukkit.getScheduler().runTaskLater(this.plug, new Runnable(){

                @Override
                public void run() {
                    menu.destroy();
                    PagedMenu.this.createDisplay(pl, owned, newPage);
                }
            }, 2L);
            return;
        }
        menu.setOption(this.PAGE_SIZE - 2, new ItemStack(Material.PAPER), "Last Page", ChatColor.GRAY + "<<<<<");
        menu.setOption(this.PAGE_SIZE - 1, new ItemStack(Material.PAPER), "Next Page", ChatColor.GRAY + ">>>>>");
        menu.open(player);
    }

    public static interface MenuDetails {
        public List<MenuItem> getDisplayItems(Player var1);

        public String getColouredMenuTitle(Player var1);

        public int getPageSize();

        public String noDisplayItemMessage();

        public static abstract class AbstractMenuItem
        implements MenuItem {
            private ItemStack display;
            private String title;
            private String[] lore;

            public AbstractMenuItem(ItemStack display, String colouredTitle, String[] lore) {
                this.display = display;
                this.title = colouredTitle;
                this.lore = lore;
            }

            @Override
            public ItemStack getDisplayItem() {
                return this.display;
            }

            @Override
            public String getColouredTitle() {
                return this.title;
            }

            @Override
            public String[] getColouredLore() {
                return this.lore;
            }
        }

        public static interface MenuItem {
            public ItemStack getDisplayItem();

            public String getColouredTitle();

            public String[] getColouredLore();

            public void onClick(Player var1);
        }
    }
}

