/*
 * Decompiled with CFR 0.152.
 */
package net.stormdev.uPlanes.api;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.stormdev.uPlanes.api.RollTarget;
import net.stormdev.uPlanes.api.uPlanesVehicle;
import net.stormdev.uPlanes.api.uPlanesVehicleBase;
import net.stormdev.uPlanes.main.main;
import net.stormdev.uPlanes.presets.PlanePreset;
import net.stormdev.uPlanes.presets.PresetManager;
import net.stormdev.uPlanes.utils.Colors;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.material.MaterialData;
import org.bukkit.util.Vector;

public class Plane
extends uPlanesVehicleBase<PlanePreset>
implements Serializable {
    public static final double DEFAULT_TURN_AMOUNT = 2.0;
    private static final long serialVersionUID = 2L;
    private double turnAmount = 2.0;
    private boolean hover = false;
    private boolean canPlaneHover = false;
    private transient long speedLockTime = 0L;
    private UUID id = UUID.randomUUID();
    private transient boolean speedLocked = false;

    public Plane() {
        this.setCurrentPitch(0.0f);
        this.setRoll(0.0);
    }

    public void postPlaneUpdateEvent(Vector vec) {
        this.lastUpdateEventTime = System.currentTimeMillis();
        this.setLastUpdateEventVec(vec);
    }

    public boolean canPlaneHoverMidair() {
        return this.canPlaneHover;
    }

    public void setCanPlaneHover(boolean b) {
        this.canPlaneHover = b;
    }

    public Plane(double speed, String name, double health, double accelMod, double turnAmountPerTick, boolean hover) {
        this(speed, name, health, accelMod, turnAmountPerTick, hover, hover);
    }

    public Plane(double speed, String name, double health, double accelMod, double turnAmountPerTick, boolean hover, boolean canPlaneHoverMidair) {
        super(speed, name, health, accelMod);
        this.turnAmount = turnAmountPerTick;
        this.hover = hover;
        this.canPlaneHover = canPlaneHoverMidair;
    }

    @Override
    public Plane setId(UUID id) {
        return (Plane)super.setId(id);
    }

    @Override
    public PlanePreset getPreset() {
        if (!PresetManager.usePresets) {
            return null;
        }
        List<PlanePreset> pps = main.plugin.presets.getPresets();
        for (PlanePreset pp : new ArrayList<PlanePreset>(pps)) {
            if (!pp.getName().equals(this.getName())) continue;
            return pp;
        }
        return null;
    }

    @Override
    public ItemStack toItemStack() {
        ItemStack stack;
        MaterialData displayBlock = this.getCartDisplayBlock();
        if (this.getPreset() != null) {
            displayBlock = this.getPreset().getDisplayBlock();
        }
        if (main.config.getBoolean("general.planes.renderAsModelledBlockWhenExist") && displayBlock != null) {
            stack = new ItemStack(displayBlock.getItemType());
            stack.setData(displayBlock);
        } else {
            stack = new ItemStack(Material.MINECART);
        }
        ArrayList<String> lore = new ArrayList<String>();
        ItemMeta meta = stack.getItemMeta();
        lore.add(ChatColor.GRAY + (this.isHover() ? "helicopter" : "plane"));
        lore.add(main.colors.getTitle() + "[Speed:] " + main.colors.getInfo() + this.mutliplier);
        lore.add(main.colors.getTitle() + "[Health:] " + main.colors.getInfo() + this.health);
        lore.add(main.colors.getTitle() + "[Acceleration:] " + main.colors.getInfo() + this.accelMod * 10.0);
        lore.add(main.colors.getTitle() + "[Handling:] " + main.colors.getInfo() + this.turnAmount * 10.0);
        if (this.hover || this.canPlaneHover) {
            lore.add(main.colors.getTitle() + "[Hover:] " + main.colors.getInfo() + this.getHandleString(this.hover || this.canPlaneHover));
        }
        if (this.getMaxPassengers() > 1) {
            lore.add(main.colors.getTitle() + "[Passengers:] " + main.colors.getInfo() + this.getMaxPassengers());
        }
        meta.setDisplayName(Colors.colorise(this.name));
        meta.setLore(lore);
        stack.setItemMeta(meta);
        return stack;
    }

    @Override
    public void setTurnAmountPerTick(double d) {
        this.turnAmount = d;
    }

    @Override
    public uPlanesVehicle.VehicleType getType() {
        return uPlanesVehicle.VehicleType.PLANE;
    }

    @Override
    public String getTypeName() {
        return "plane";
    }

    @Override
    public float getRollAmount(RollTarget rollTarget) {
        switch (rollTarget) {
            case LEFT: {
                return 25.0f;
            }
            case NONE: {
                return 0.0f;
            }
            case RIGHT: {
                return -25.0f;
            }
        }
        return 0.0f;
    }

    @Override
    public double getTurnAmountPerTick() {
        if (this.turnAmount <= 0.0) {
            this.turnAmount = 2.0;
        }
        return this.turnAmount;
    }

    public boolean canFloat() {
        return this.isHover() || this.canPlaneHoverMidair();
    }

    public boolean isHover() {
        return this.hover;
    }

    public void setHover(boolean hover) {
        this.hover = hover;
    }

    public boolean isSpeedLocked() {
        return this.speedLocked;
    }

    public void setSpeedLocked(boolean speedLocked) {
        this.speedLocked = speedLocked;
    }

    public long getSpeedLockTime() {
        return this.speedLockTime;
    }

    public void setSpeedLockTime(long speedLockTime) {
        this.speedLockTime = speedLockTime;
    }
}

